SET FOREIGN_KEY_CHECKS=0;
DROP TABLE IF EXISTS `backups`;
CREATE TABLE `backups` (
  `id_backup` int unsigned NOT NULL AUTO_INCREMENT,
  `file_name` varchar(255) DEFAULT NULL,
  `file_path` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_backup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `bank`;
CREATE TABLE `bank` (
  `id_bank` int unsigned NOT NULL AUTO_INCREMENT,
  `faktur` varchar(255) DEFAULT NULL,
  `jenis` varchar(255) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `waktu` time DEFAULT NULL,
  `pemasukan` int DEFAULT NULL,
  `pengeluaran` int DEFAULT NULL,
  `keterangan` varchar(255) DEFAULT NULL,
  `id_penjualan` int unsigned DEFAULT NULL,
  `noref_nokartu` varchar(255) DEFAULT NULL,
  `id_toko` int NOT NULL DEFAULT '0',
  `id_login` int DEFAULT NULL,
  `id_bank_akun` int DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_bank`),
  KEY `id_login` (`id_login`),
  KEY `id_toko` (`id_toko`),
  KEY `id_bank_akun` (`id_bank_akun`),
  KEY `id_penjualan` (`id_penjualan`),
  CONSTRAINT `bank_ibfk_1` FOREIGN KEY (`id_login`) REFERENCES `login` (`id_login`),
  CONSTRAINT `bank_ibfk_2` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`),
  CONSTRAINT `bank_ibfk_3` FOREIGN KEY (`id_bank_akun`) REFERENCES `bank_akun` (`id_bank_akun`),
  CONSTRAINT `bank_ibfk_4` FOREIGN KEY (`id_penjualan`) REFERENCES `penjualan` (`id_penjualan`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;
DROP TABLE IF EXISTS `bank_akun`;
CREATE TABLE `bank_akun` (
  `id_bank_akun` int NOT NULL AUTO_INCREMENT,
  `nama_bank` varchar(255) DEFAULT NULL,
  `bank_nama` varchar(255) DEFAULT NULL,
  `no_rekening` varchar(255) DEFAULT NULL,
  `utama` int NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_bank_akun`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
INSERT INTO `bank_akun` (`id_bank_akun`,`nama_bank`,`bank_nama`,`no_rekening`,`utama`,`created_at`,`updated_at`) VALUES ('1','BANK 1, Purwokerto','John Doe','123456789','0',NULL,'2024-01-19 20:24:09'), 
('2','DANA','DANA','0812345679','1','2024-01-19 20:23:40','2024-01-19 20:24:09');
DROP TABLE IF EXISTS `barang`;
CREATE TABLE `barang` (
  `id_barang` int unsigned NOT NULL AUTO_INCREMENT,
  `uuid_barang` char(36) NOT NULL DEFAULT '',
  `kode_barang` varchar(255) DEFAULT NULL,
  `barcode` varchar(255) DEFAULT NULL,
  `id_kategori` int unsigned NOT NULL DEFAULT '0',
  `id_kontak` int unsigned DEFAULT NULL,
  `sku` varchar(255) DEFAULT NULL,
  `nama_barang` varchar(255) NOT NULL DEFAULT '',
  `merk` varchar(255) NOT NULL,
  `harga_beli` int NOT NULL DEFAULT '0',
  `diskon` int NOT NULL DEFAULT '0',
  `diskon_persen` int NOT NULL DEFAULT '0',
  `harga_jual` int NOT NULL DEFAULT '0',
  `harga_jual_grosir` int NOT NULL DEFAULT '0',
  `jumlah_min_grosir` int NOT NULL DEFAULT '0',
  `harga_member` int NOT NULL DEFAULT '0',
  `harga_sales` int NOT NULL DEFAULT '0',
  `margin` float NOT NULL DEFAULT '0',
  `range_harga` varchar(255) DEFAULT NULL,
  `satuan_barang` varchar(255) NOT NULL,
  `satuan_nilai` int NOT NULL DEFAULT '0',
  `deskripsi` text,
  `stok` int NOT NULL DEFAULT '0',
  `stok_min` int NOT NULL DEFAULT '0',
  `stok_gudang` int NOT NULL DEFAULT '0',
  `expired` datetime DEFAULT NULL,
  `active` int DEFAULT '0',
  `id_toko` int NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_barang`),
  KEY `id_kategori` (`id_kategori`),
  CONSTRAINT `barang_ibfk_1` FOREIGN KEY (`id_kategori`) REFERENCES `kategori` (`id_kategori`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;
INSERT INTO `barang` (`id_barang`,`uuid_barang`,`kode_barang`,`barcode`,`id_kategori`,`id_kontak`,`sku`,`nama_barang`,`merk`,`harga_beli`,`diskon`,`diskon_persen`,`harga_jual`,`harga_jual_grosir`,`jumlah_min_grosir`,`harga_member`,`harga_sales`,`margin`,`range_harga`,`satuan_barang`,`satuan_nilai`,`deskripsi`,`stok`,`stok_min`,`stok_gudang`,`expired`,`active`,`id_toko`,`created_at`,`updated_at`) VALUES ('1','6NrpUAjeUbKHoe2WHQNVPB','BRG-01','8999999195649','6',NULL,NULL,'Teh Sari Wangi ',' Sari Wangi ','5667','0','0','6000','0','0','0','0','6',NULL,'kotak','1','','6','1','0',NULL,'1','1','2024-10-22 15:17:30','2024-10-22 15:17:30'), 
('2','2cJapYgFrbRyozWuvvdpX2','BRG-02','4902430563888','7',NULL,NULL,'Shampo Pentene Hitam ',' Pentene','833','0','0','1000','0','0','0','0','25',NULL,'pcs','1','','24','5','0',NULL,'1','1','2024-10-22 15:19:47','2024-10-22 15:19:47'), 
('3','k7cy8vSEVLj2qwqss9wmic','BRG-03','8999999599256','7',NULL,NULL,'Shampo Clear Menthol Segar','Clear','833','0','0','1000','0','0','0','0','25',NULL,'pcs','1','','24','5','0',NULL,'1','1','2024-10-22 15:21:40','2024-10-22 15:21:40'), 
('4','3KQS3A7pBUaKjG892EM6un','BRG-04','8999999554934','7',NULL,NULL,'Sampo Dove Biru Perawatan Rambut Rusak','Dove ','833','0','0','1000','0','0','0','0','25',NULL,'pcs','1','','24','5','0',NULL,'1','1','2024-10-22 15:22:48','2024-10-22 15:22:48'), 
('5','zDd5ouhmh4HuPeBRsc9jKL','BRG-05','8999999554989','7',NULL,NULL,'Sampo Tresemme Anti Ketombe dan Rambut Rontok','Tresemme','833','0','0','1000','0','0','0','0','25',NULL,'pcs','1','','24','5','0',NULL,'0','1','2024-10-22 15:24:09','2024-10-22 15:24:09');
DROP TABLE IF EXISTS `biaya`;
CREATE TABLE `biaya` (
  `id_biaya` int unsigned NOT NULL AUTO_INCREMENT,
  `faktur` varchar(255) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `waktu` time DEFAULT NULL,
  `jenis` varchar(255) DEFAULT NULL,
  `nominal` int NOT NULL DEFAULT '0',
  `keterangan` varchar(255) DEFAULT NULL,
  `id_toko` int NOT NULL DEFAULT '0',
  `id_login` int DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_biaya`),
  KEY `id_toko` (`id_toko`),
  KEY `id_login` (`id_login`),
  CONSTRAINT `biaya_ibfk_1` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`),
  CONSTRAINT `biaya_ibfk_2` FOREIGN KEY (`id_login`) REFERENCES `login` (`id_login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
DROP TABLE IF EXISTS `cashflow`;
CREATE TABLE `cashflow` (
  `id_cashflow` int unsigned NOT NULL AUTO_INCREMENT,
  `faktur` varchar(255) DEFAULT NULL,
  `jenis` varchar(255) DEFAULT NULL,
  `kategori` varchar(255) DEFAULT NULL,
  `tanggal` date DEFAULT NULL,
  `waktu` time DEFAULT NULL,
  `pemasukan` int NOT NULL DEFAULT '0',
  `pengeluaran` int NOT NULL DEFAULT '0',
  `keterangan` varchar(255) DEFAULT NULL,
  `id_penjualan` int unsigned DEFAULT NULL,
  `id_pembelian` int unsigned DEFAULT NULL,
  `id_biaya` int unsigned DEFAULT NULL,
  `id_toko` int NOT NULL DEFAULT '0',
  `id_login` int DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_cashflow`),
  KEY `id_penjualan` (`id_penjualan`),
  KEY `id_pembelian` (`id_pembelian`),
  KEY `id_biaya` (`id_biaya`),
  KEY `id_toko` (`id_toko`),
  KEY `id_login` (`id_login`),
  CONSTRAINT `cashflow_ibfk_1` FOREIGN KEY (`id_penjualan`) REFERENCES `penjualan` (`id_penjualan`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cashflow_ibfk_2` FOREIGN KEY (`id_pembelian`) REFERENCES `pembelian` (`id_pembelian`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cashflow_ibfk_3` FOREIGN KEY (`id_biaya`) REFERENCES `biaya` (`id_biaya`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `cashflow_ibfk_4` FOREIGN KEY (`id_toko`) REFERENCES `toko` (`id_toko`),
  CONSTRAINT `cashflow_ibfk_5` FOREIGN KEY (`id_login`) REFERENCES `login` (`id_login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
DROP TABLE IF EXISTS `groups`;
CREATE TABLE `groups` (
  `id_group` int NOT NULL AUTO_INCREMENT,
  `nama_group` varchar(255) NOT NULL,
  `permission` text NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_group`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;
